import datetime

from six.moves import range


SECONDS_IN_DAY = 60*60*24


def today():
    return datetime.datetime.now().date()


def tomorrow():
    return day_back(today(), -1)


def day_back(date, count):
    return date - datetime.timedelta(days=count)


def yesterday():
    return day_back(today(), 1)


def days_range(begin, end):
    assert end > begin
    count = (end - begin).days - 1
    return [day_back(end, i) for i in range(count, -1, -1)]


def days_range_back(date, count):
    return days_range(day_back(date, count), date)


def from_timestamp(ts):
    return datetime.datetime.fromtimestamp(ts).date()


def looks_like_day(str_):
    try:
        datetime.datetime.strptime(str(str_), '%Y-%m-%d')
        return True
    except ValueError:
        return False


def is_old(str_, tail_days):
    date = parse_day(str_)
    if (today() - date).days > tail_days:
        return True
    else:
        return False


def parse_day(str_):
    if str_ == 'today':
        return today()
    if str_ == 'yesterday':
        return yesterday()
    if str_ == 'ereyesterday':
        return day_back(today(), 2)

    return datetime.datetime.strptime(str(str_), '%Y-%m-%d').date()


def parse_time(str_):
    return datetime.datetime.strptime(str(str_), '%Y-%m-%d %H:%M:%S')


def to_timestamp(date):
    return int((date - datetime.datetime(1970, 1, 1)).total_seconds())


def current_hour():
    return datetime.datetime.now().hour


def parse_hour(str_):
    if str_ == 'current_hour':
        return current_hour()
    return int(str_)
