from util.generic.string cimport TString, TStringBuf
from util.generic.vector cimport TVector


cdef extern from "library/cpp/resource/resource.h" namespace "NResource":
    cppclass TResource:
        TStringBuf Key
        TString Data

    cdef void FindMatch(const TStringBuf& subkey, TVector[TResource]* result) nogil except +


def find(prefix='/config'):
    cdef TVector[TResource] res
    cdef TStringBuf cprefix = TStringBuf(prefix, len(prefix))
    FindMatch(cprefix, &res)
    return {each.Key: each.Data for each in res}
