class ParameterMissed(Exception):
    """Raised when some parameter is missed."""


class ParameterUnexpected(Exception):
    """Raised when unexpected parameter is provided."""


class TaskMissed(Exception):
    """Raised when task is missed."""


class TaskAbstract(Exception):
    """Raised when task is abstract, i.e. misses some methods."""


class RecoverableError(Exception):
    """Raised internally when something non-critical happened."""


class TaskOutdated(RecoverableError):
    """Raised when a task is of different version than worker."""


class TaskCyclic(RecoverableError):
    """Raised when a task causes a cyclic dependency that can't be resolved"""


class TaskUncompletable(RecoverableError):
    """Raised when a task is not complete even after it has been
    succesfully executed."""


class TaskFailed(RecoverableError):
    """Raised when task was executed, but failed."""


class NoTasksLeft(RecoverableError):
    """Raised when no tasks left."""


class TaskAlreadyEnqueued(RecoverableError):
    """Raised when task already exists."""


class TaskLocked(RecoverableError):
    """Used to indicate task is locked."""


class TaskAwaiting(RecoverableError):
    """Used to indicate task is waiting for something."""


class TaskInvalid(RecoverableError):
    """Raised when stored task (:class:`Task`) is broken."""


class TaskDisappeared(Exception):
    """Raised when task has disappeared while loading."""


class TaskNotEnqueued(Exception):
    """Raised when task has not been enqueued."""


class WorkerStopped(Exception):
    """Raised when worker has been stopped."""


class TransactionFailed(Exception):
    """Raised when transaction has failed."""


class TaskExecuted(Exception):
    """Raised when task has been executed."""
