import crypta.lib.python.bt.workflow as workflow

import logging
logger = logging.getLogger(__name__)


class Empty(workflow.Target):
    """Target that is satisfied when directory is empty."""
    def __init__(self, yt, directory):
        self.yt = yt
        self._directory = directory

    @property
    def tables(self):
        return self.yt.list(self._directory, absolute=True, attributes=['creation_time'])

    def __repr__(self):
        return "directory is empty: [%s]" % (self._directory)

    def satisfied(self):
        available_tables = self.tables
        if available_tables:
            logger.info("Tables in should-be-empty directory [%s]: [%s]",
                        self._directory, ','.join(available_tables))
            return False
        else:
            logger.info("There are no tables in directory [%s]",
                        self._directory)
            return True
