import crypta.lib.python.bt.workflow as workflow

import os
import logging
logger = logging.getLogger(__name__)


class FileExists(workflow.Target):
    """Target that is satisfied when file exists."""
    def __init__(self, path):
        self.path = path

    def __repr__(self):
        return "file exists: [%s]" % (self.path)

    def satisfied(self):
        return os.path.exists(self.path) and not os.path.isdir(self.path)
