import collections

from crypta.lib.python.spine.consts import environment


LiteralEnv = collections.namedtuple("LiteralEnv", ("env", "value"))
SecretEnv = collections.namedtuple("SecretEnv", ("env", "sec", "ver", "id"))


class EnvNames(object):
    yql_token = "YQL_TOKEN"
    yt_token = "YT_TOKEN"
    solomon_token = "SOLOMON_TOKEN"
    crypta_api_token = "CRYPTA_API_TOKEN"
    crypta_environment = "CRYPTA_ENVIRONMENT"
    crypta_api_oauth = "CRYPTA_API_OAUTH"
    crypta_audience_tvm_secret = "CRYPTA_AUDIENCE_TVM_SECRET"
    siberia_tvm_id = "SIBERIA_TVM_ID"
    siberia_host = "SIBERIA_HOST"
    tvm_secret = "TVM_SECRET"
    ydb_token = "YDB_TOKEN"
    grut_token = "GRUT_TOKEN"
    s2s_google_api_key = "GOOGLE_SERVICE_ACCOUNT_KEY"
    s2s_direct_encryption_secret = "DIRECT_ENCRYPTION_SECRET"
    juggler_oauth_token = "JUGGLER_OAUTH_TOKEN"
    sandbox_token = "SANDBOX_TOKEN"


crypta_api_token = SecretEnv(EnvNames.crypta_api_token, "sec-01csvzfz5ecm6zbxcs27pcgf7e", "ver-01fe39na05wcczh7scyv7xwcrz", "oauth")
crypta_api_oauth = SecretEnv(EnvNames.crypta_api_oauth, "sec-01csvzfvrmwscwvt2j9ms2wr2z", "ver-01cva1c6pask5tz6pgq7btzp7r", "oauth")
solomon_token = SecretEnv(EnvNames.solomon_token, "sec-01e63xgmh8g9fj3c542hrw9vqc", "ver-01eaj19bbxn4scq3tre0whw1nz", "token")
juggler_oauth_token = SecretEnv(EnvNames.juggler_oauth_token, "sec-01dc2ahekdhey511zd9qq9cp9m", "ver-01dc2ahenzzp0dssswb3wzfg82", "token")
sandbox_token = SecretEnv(EnvNames.sandbox_token, "sec-01csvzg7vtpvb7bgrx18ajsscj", "ver-01fff9s1r1bvbem09m1s4trspv", "token")


class Testing(object):
    cm_uploader_tvm = SecretEnv(EnvNames.tvm_secret, "sec-01dq7mheb44qtydwtvene6y7bh", "ver-01dq7mhegxkx7zx8z06w4tc3ah", "client_secret")
    crypta_audience_tvm_secret = SecretEnv(EnvNames.crypta_audience_tvm_secret, "sec-01dq7mdq49h6wegxz835zg40ws", "ver-01dq7mdqatmmcne71by7yfp8bp", "client_secret")
    crypta_environment = LiteralEnv(EnvNames.crypta_environment, environment.TESTING)
    grut_token = SecretEnv(EnvNames.grut_token, "sec-01g4j5be6c5hk8wfptw0k55b0h", "ver-01g4j5be6w2ka9tc9wmc31c8yx", "token")
    rule_estimator_tvm_secret = SecretEnv(EnvNames.tvm_secret, "sec-01fj9tbg3e4gmpm0y78me0nc8s", "ver-01fj9tbg4hm05299rc6bdjfa2b", "client_secret")
    s2s_conversions_downloader_tvm_secret = SecretEnv(EnvNames.tvm_secret, "sec-01fyc333sg0f9wqc0zq38yaj5p", "ver-01fyc333sv9e10peb6nshamrq0", "client_secret")
    s2s_conversions_processor_tvm_secret = SecretEnv(EnvNames.tvm_secret, "sec-01fyebsjvz7560q0cc4ef0vw9m", "ver-01fyebsjwvmgagq8fnp2bcs8pf", "client_secret")
    s2s_direct_encryption_secret = SecretEnv(EnvNames.s2s_direct_encryption_secret, "sec-01g0y6m836nb4cbtm5vwx9jcnz", "ver-01g0y6m852bc9qwtbz75vwvwbq", "encrypter-secret")
    s2s_google_api_key = SecretEnv(EnvNames.s2s_google_api_key, "sec-01fqby197y3s5kd0s08zgfqn71", "ver-01g18j4j0eecfgfs7xwfnw7yj7", "key")
    s2s_scheduler_tvm_secret = SecretEnv(EnvNames.tvm_secret, "sec-01fyexpj8dhq06024j2f7sz9cm", "ver-01fyexpj8qeeqc6bcx8f3db77q", "client_secret")
    siberia_host = LiteralEnv(EnvNames.siberia_host, "siberia-test.crypta.yandex.net")
    siberia_tvm_id = LiteralEnv(EnvNames.siberia_tvm_id, "2017435")
    yql_token = SecretEnv(EnvNames.yql_token, "sec-01csvzhrwp51f2tm9v8rfv8vkp", "ver-01d2j9mnz45f9br06cew9fyw04", "token")
    yt_token = SecretEnv(EnvNames.yt_token, "sec-01csvzht1xqae2t7djkh0kjzrm", "ver-01d2j9dbxqrkxn5dvffy6mhpsz", "token")


class Production(object):
    cm_uploader_tvm = SecretEnv(EnvNames.tvm_secret, "sec-01dq7mhehy91k5gzxz7ngkc0db", "ver-01dq7mheqsm9p9kcqnp8bj7rp8", "client_secret")
    crypta_audience_tvm_secret = SecretEnv(EnvNames.crypta_audience_tvm_secret, "sec-01dq7mdqc2yn2n8d9r2s2d5ys1", "ver-01dq7mdqh9na434c1n6fdgv5md", "client_secret")
    crypta_environment = LiteralEnv(EnvNames.crypta_environment, environment.PRODUCTION)
    grut_token = SecretEnv(EnvNames.grut_token, "sec-01fz0fwdxnsvjmrxwykqcmzr8s", "ver-01fz0g5482qc0r5dkq16zqbd6r", "token")
    ltp_viewer_tvm_secret = SecretEnv(EnvNames.tvm_secret, "sec-01fxvystbd7aswg8ryd6gkxfq4", "ver-01fxvystbtey8tt11bcq8vpym0", "client_secret")
    rule_estimator_tvm_secret = SecretEnv(EnvNames.tvm_secret, "sec-01fj9tb3fzjqsk7cjnpcajctrm", "ver-01fj9tb3h5hp63bnw67nrb48gh", "client_secret")
    s2s_conversions_downloader_tvm_secret = SecretEnv(EnvNames.tvm_secret, "sec-01fyc31c0mdgv9nd9eqwd46j63", "ver-01fyc31c0za4ej0nz47d92105v", "client_secret")
    s2s_conversions_processor_tvm_secret = SecretEnv(EnvNames.tvm_secret, "sec-01fyebrvdtde1xm6fbw195m1pq", "ver-01fyebrve6kw80c4ee4975ea7q", "client_secret")
    s2s_direct_encryption_secret = SecretEnv(EnvNames.s2s_direct_encryption_secret, "sec-01g0y6x1rbb66tpcwbd2emnb8z", "ver-01g0y6x1rryjqsv287mycerte2", "encrypter-secret")
    s2s_google_api_key = SecretEnv(EnvNames.s2s_google_api_key, "sec-01fqby197y3s5kd0s08zgfqn71", "ver-01g18j4j0eecfgfs7xwfnw7yj7", "key")
    s2s_scheduler_tvm_secret = SecretEnv(EnvNames.tvm_secret, "sec-01fyexnyphvg6x4972hg43q8fn", "ver-01fyexnyqtnahh2bjdqmeq8gt8", "client_secret")
    siberia_host = LiteralEnv(EnvNames.siberia_host, "siberia.crypta.yandex.net")
    siberia_tvm_id = LiteralEnv(EnvNames.siberia_tvm_id, "2017433")
    ydb_token = SecretEnv(EnvNames.ydb_token, "sec-01djmv2qmccj7dz58gasvrkrvf", "ver-01djmv2qnrsdssrtbkmzthjyn9", "token")
    yql_token = SecretEnv(EnvNames.yql_token, "sec-01daxfnemczc2ncx44cs2x304q", "ver-01daxfnemwfg7wsys07bmkq45k", "secret")
    yt_token = SecretEnv(EnvNames.yt_token, "sec-01csvzgg3mdasmdygkr5s8n6mz", "ver-01d7q23zq6gqhxdcpggs5epbdk", "token")


VARS_BY_ENV = {
    cls.crypta_environment.value: cls
    for cls in (Testing, Production)
}
VARS_BY_ENV[environment.STABLE] = Production


def to_sandbox_secrets_env(*secret_envs):
    return {
        secret_env.env: "{sec}[{id}]".format(**secret_env._asdict())
        for secret_env in secret_envs
    }
