from yt.wrapper import with_context

apply_catboost_regression_query = """
INSERT INTO `{output_table}`
WITH TRUNCATE

SELECT
    Cast(PassThrough AS Uint64) AS id,
    'yandexuid' AS id_type,
    Result[0] AS model_predictions
FROM $processed;
"""


def voting_by_cryptaid(key, rows):
    result_score = 0.
    rows = list(rows)

    for row in rows:
        result_score += row['model_predictions']

    for row in rows:
        yield {
            'id': row['id'],
            'id_type': row['id_type'],
            'model_predictions': result_score / len(rows),
        }


@with_context
class GetSegmentWithPercentile(object):
    def __init__(self, slice_to_segment_name_dict):
        self.slice_to_segment_name_dict = slice_to_segment_name_dict

    def __call__(self, row, context):
        yield {
            'id': str(row['id']),
            'id_type': row['id_type'],
            'segment_name': self.slice_to_segment_name_dict[context.table_index],
        }
