from collections import namedtuple
import six


Match = namedtuple("Match", ["yandexuid", "type", "ext_id"])

DUID_FIELD = "duid"
FPC_FIELD = "fpc"
YANDEXUID_FIELD = "yuid"


def get_matches(row):
    yandexuid = row.get(YANDEXUID_FIELD)

    fields_to_ext_id_types = {DUID_FIELD: "duid"}
    if yandexuid:
        for field, type in six.iteritems(fields_to_ext_id_types):
            ext_id = row.get(field)
            if ext_id:
                yield Match(yandexuid=yandexuid, type=type, ext_id=ext_id)


def get_row_key(row):
    return row[YANDEXUID_FIELD], row.get(DUID_FIELD)
