from util.generic.string cimport TString
import sys

from library.python.protobuf.get_serialized_file_descriptor_set import get_serialized_file_descriptor_set
import six

cdef extern from "crypta/lib/native/cmd_args/parse_pb_options.h" namespace "NCrypta":
    TString ParsePbOptionsDynamic(int, const char**, const TString&, const TString&) except +;


class ParseError(RuntimeError):
    pass


def ParsePbOptions(message_type, arguments=None):
    if arguments is None:
        arguments = sys.argv
    assert len(arguments) < 1024
    arguments = [six.ensure_binary(arg) for arg in arguments]

    serialized_fds = get_serialized_file_descriptor_set(message_type)

    cdef int argc=0
    cdef char* argv[1024]

    for arg in arguments:
        argv[argc] = arguments[argc]
        argc += 1

    try:
        reply = ParsePbOptionsDynamic(
            argc,
            <const char**>argv,
            serialized_fds,
            six.ensure_binary(message_type.DESCRIPTOR.full_name))
    except RuntimeError as e:
        raise ParseError(e)

    message = message_type()
    message.ParseFromString(reply)

    return message
