import time

from juggler.bundles import Status, Event

from crypta.lib.python.graphite import log_reader
from crypta.lib.python.graphite.check_graphite_metric import units


def check(check_sets, level, metric, env):
    res = []

    if not check_sets:
        return res

    for check_set in check_sets:
        error = check_set(env, metric, level)
        if error:
            res.append(error)

    return res


def avg(values):
    return sum(values) / float(len(values))


def check_graphite_metric_core(dir_path, filename_regexp, metric, aggregator=avg, time_window=300, warning=None,
                               critical=None, no_values_are_ok=False):
    if not critical and not warning:
        return Event(Status.CRIT, 'No conditions were specified')

    try:
        now_ts = int(time.time())
        values = log_reader.read(dir_path, filename_regexp, metric, now_ts - time_window)
        with open('/etc/yandex/environment.type') as env_file:
            env = env_file.read().rstrip()

        if not values:
            status = Status.OK if no_values_are_ok else Status.CRIT if critical else Status.WARN
            return Event(status, 'No values found in log')

        level = aggregator(values)

        critical_message = check(critical, level, metric, env)
        if critical_message:
            msg = ' | '.join(critical_message)
            return Event(Status.CRIT, msg)

        warning_message = check(warning, level, metric, env)
        if warning_message:
            msg = ' | '.join(warning_message)
            return Event(Status.WARN, msg)

        return Event(Status.OK, 'OK. value = {}'.format(units.format_value(level)))
    except Exception as exc:
        return Event(Status.CRIT, 'Script error: "{}"'.format(exc))
