import operator

from crypta.lib.python.graphite.check_graphite_metric import units


class Check(object):
    def __init__(self, op, repr, limit):
        self.op = op
        self.repr = repr
        self.limit = limit

    def __call__(self, value):
        return self.op(value, self.limit)

    def __repr__(self):
        return "{} {}".format(self.repr, units.format_value(self.limit))


def lt(limit):
    return Check(operator.lt, "<", limit)


def gt(limit):
    return Check(operator.gt, ">", limit)


class CheckSet(object):
    env_dict = {
        'production': 'prod',
        'testing': 'test',
        'unstable': 'unstable',
        'prestable': 'prestable'
    }

    def __init__(self, prod=None, test=None, prestable=None, unstable=None):
        self.prod = prod
        self.test = test
        self.prestable = prestable
        self.unstable = unstable

    def get_check(self, env):
        return self.__dict__[self.env_dict[env]]

    def __call__(self, env, metric, value):
        check = self.get_check(env)
        if check and check(value):
            return '{} value {} {}'.format(metric, units.format_value(value), check)

    def __repr__(self):
        return ", ".join("{}: {}".format(v, self.__dict__[v]) for _, v in self.env_dict.iteritems())
