UNIT_IDS = ['', 'k', 'm', 'g', 't', 'p']
UNIT_COEFS = [1000**x for x in range(len(UNIT_IDS))]
UNITS = dict(zip(UNIT_IDS, UNIT_COEFS))


def format_value(num):
    for unit in UNIT_IDS:
        if abs(num) < 1000:
            return "%3.2f%s" % (num, unit)
        num /= 1000
    return "%.2f%s" % (num, 'Eb')
