import ast
import re


def is_graphite_msg(record):
    keys = {"group", "name", "timestamp", "hostname", "value", "frequency"}
    rec_keys = set(record.keys())
    return keys == rec_keys


def parse_file(path, erase_timestamps=True):
    with open(path) as f:
        stdout = f.read()
    return parse(stdout, erase_timestamps)


def parse(stdout, erase_timestamps=True):
    msgs = []

    for possible_dict in re.findall(r"({.+})", stdout):
        try:
            msg = ast.literal_eval(possible_dict)
            if not is_graphite_msg(msg):
                continue

            if erase_timestamps:
                del msg["timestamp"]

            msgs.append(msg)
        except ValueError:
            pass

    return msgs
