import datetime


def get_keepalive_options(period=datetime.timedelta(seconds=60)):
    period_ms = int(period.total_seconds() * 1000)
    return [
        ("grpc.keepalive_time_ms", period_ms),
        ("grpc.keepalive_permit_without_calls", 1),
        ("grpc.http2.max_pings_without_data", 0),
        ("grpc.http2.min_time_between_pings_ms", period_ms),
        ("grpc.http2.min_ping_interval_without_data_ms", period_ms),
    ]
