from grut.python.object_api.client import ObjectApiClient

from crypta.lib.proto.config import grut_pb2


def get_client_from_proto(config: grut_pb2.TGrutConfig) -> ObjectApiClient:
    return ObjectApiClient(
        address=config.Address,
        transport=config.Transport,
        config={
            "enable_ssl": config.EnableSsl,
            "token": config.Token,
        },
        allow_receive_token_by_ssh_session=config.AllowReceiveTokenBySshSession,
    )
