from library.python.protobuf.json import (
    json2proto,
)

from crypta.lib.native.http.proto.simple_response_pb2 import TSimpleResponse


def with_protobuf_response(proto, config=None):
    def decorator(f):
        def wrapper(*args, **kwargs):
            response = f(*args, **kwargs)
            response.raise_for_status()

            result = proto()
            json2proto.json2proto(response.content, result, config or json2proto.Json2ProtoConfig())

            return result
        return wrapper
    return decorator


def with_simple_response(f):
    return with_protobuf_response(TSimpleResponse)(f)
