import six

from util.generic.ptr cimport THolder
from util.generic.string cimport TString
from util.system.types cimport ui64
from libcpp cimport bool as BoolCpp
from crypta.lib.proto.identifiers.identifiers_pb2 import TGenericID as TGenericIDProtoPy


cdef extern from "util/random/random.h":
    void SetRandomSeed(int)


cdef extern from "crypta/lib/proto/identifiers/id_type.pb.h":
    cdef enum EIdTypeCpp "NCrypta::NIdentifiersProto::NIdType::EIdType":
        pass


cdef extern from "google/protobuf/descriptor.h" namespace "NProtoBuf":
    cppclass Descriptor:
        pass


cdef extern from "library/cpp/protobuf/yql/descriptor.h":
    TString GenerateProtobufTypeConfig(const Descriptor*)


cdef extern from "crypta/lib/proto/identifiers/identifiers.pb.h":
    cdef cppclass TGenericIDProtoCpp "NCrypta::NIdentifiersProto::TGenericID":
        TGenericIDProtoCpp() except +
        BoolCpp SerializeToString(TString*) const
        BoolCpp ParseFromString(const TString&)

        @staticmethod
        Descriptor * descriptor()


cdef extern from "crypta/lib/native/identifiers/lib/generic.h" namespace "NIdentifiers":
    cdef cppclass TGenericID:

        TGenericID(const TGenericIDProtoCpp&) except +
        TGenericID(const TString&, const TString&) except +
        TGenericID(const EIdTypeCpp&, const TString&) except +

        @staticmethod
        TString Next(const EIdTypeCpp&)

        BoolCpp IsValid() const
        BoolCpp IsSignificant() const
        int GetType() const

        TString Normalize() const
        TString GetValue() const
        TString GetMd5() const
        TString GetSha256() const
        ui64 GetHalf() const

        TGenericIDProtoCpp ToProto() const


cdef ToPython(const TGenericIDProtoCpp& cpp_proto):
    cdef TString serialized
    cpp_proto.SerializeToString(&serialized)
    py_proto = TGenericIDProtoPy()
    py_proto.ParseFromString(serialized)
    return py_proto


cdef TGenericIDProtoCpp ToPlusPlus(py_proto):
    serialized = py_proto.SerializeToString()
    cdef TGenericIDProtoCpp cpp_proto = TGenericIDProtoCpp()
    cpp_proto.ParseFromString(serialized)
    return cpp_proto


cdef SerializeToString(const TGenericIDProtoCpp& cpp_proto):
    cdef TString serialized
    cpp_proto.SerializeToString(&serialized)
    return serialized


cdef class GenericID:

    ID_TYPE = None
    cdef THolder[TGenericID] _impl

    def __init__(self, id_type=None, id_value=None, proto=None):
        if (isinstance(id_value, unicode)):
            id_value = id_value.encode('utf8', errors='ignore')
        if isinstance(proto, TGenericIDProtoPy):
            # call proto constructor
            self._impl = THolder[TGenericID](new TGenericID(ToPlusPlus(proto)))
        elif isinstance(id_type, (str, unicode)):
            # call (string id_type, string id_value) constructor
            self._impl = THolder[TGenericID](new TGenericID(<TString> six.ensure_binary(id_type), <TString> (id_value or b'')))
        elif isinstance(self.ID_TYPE, int):
            # call (int/EIdType id_type, string id_value) constructor
            self._impl = THolder[TGenericID](new TGenericID(<EIdTypeCpp> self.ID_TYPE, <TString> (id_value or b'')))
        else:
            raise TypeError("GenericId should has id_type or proto as parametrs")

    def __repr__(self):
        return "GenericID<{self.type}, {self.value}>".format(self=self)

    def __str__(self):
        return self.normalize

    def is_valid(self):
        return self._impl.Get().IsValid()

    def is_significant(self):
        return self._impl.Get().IsSignificant()

    @property
    def normalize(self):
        return six.ensure_str(self._impl.Get().Normalize())

    @property
    def value(self):
        return six.ensure_str(self._impl.Get().GetValue())

    @property
    def type(self):
        return self._impl.Get().GetType()

    @property
    def md5(self):
        return self._impl.Get().GetMd5()

    @property
    def sha256(self):
        return self._impl.Get().GetSha256()

    @property
    def half(self):
        return self._impl.Get().GetHalf()

    def to_proto(self):
        return ToPython(self._impl.Get().ToProto())

    def serialize(self):
        return SerializeToString(self._impl.Get().ToProto())

    @classmethod
    def next(cls):
        return six.ensure_str(TGenericID.Next(cls.ID_TYPE))


def generate_protobuf_config():
    return GenerateProtobufTypeConfig(TGenericIDProtoCpp.descriptor())


def set_random_seed(seed):
    SetRandomSeed(seed)
