import crypta.lib.proto.identifiers.id_type_pb2 as id_types
from crypta.lib.proto.identifiers.identifiers_pb2 import TGenericID as TGenericIDProto
from crypta.lib.python.identifiers.generic_id import GenericID


def IdentifierFactory(proto):

    def to_camel_case(snake_name):
        return ''.join(map(lambda word: word.title(), snake_name.split('_')))

    class Identifier(GenericID):

        def __init__(self, value):
            if isinstance(value, TGenericIDProto):
                super(Identifier, self).__init__(proto=value)
            else:
                super(Identifier, self).__init__(id_value=value)

    return type(to_camel_case(id_types.EIdType.Name(proto)), (Identifier, ), {'ID_TYPE': (proto)})


__all__ = []
NOT_IMPLEMENTED_IDENTIFIERS = {
    # in lib has VkId which also VkName
    id_types.VK_NAME,
    # other identifier skip
    id_types.INSTAGRAM_ID, id_types.INSTAGRAM_LOGIN,
    id_types.OLD_DEVICE_ID, id_types.CRYPTA_ID1, id_types.DEFAULT,
    # just added private_yandexuid to proto, no implementation yet
    id_types.PRIVATE_YANDEXUID,
    id_types.STAFF,
}

for proto_value in id_types.EIdType.values():
    if proto_value in NOT_IMPLEMENTED_IDENTIFIERS:
        continue
    class_ = IdentifierFactory(proto_value)
    __all__.append(class_.__name__)
    vars()[class_.__name__] = class_
