import six

from util.generic.maybe cimport TMaybe
from util.generic.string cimport TString

cdef extern from "crypta/lib/proto/identifiers/id_type.pb.h":
    cdef enum EIdTypeCpp "NCrypta::NIdentifiersProto::NIdType::EIdType":
        pass


cdef extern from "crypta/lib/native/identifiers/lib/ads/ads.h":
    cdef TMaybe[TString] ConvertToProfileUniq(const EIdTypeCpp&, const TString&)
    cdef TMaybe[TString] ConvertToStorageId(const EIdTypeCpp&, const TString&)


def convert_to_profile_uniq(id_type, id_value):
    res = ConvertToProfileUniq(id_type, six.ensure_binary(id_value))
    return six.ensure_str(res) if res.Defined() else res


def convert_to_storage_id(id_type, id_value):
    res = ConvertToStorageId(id_type, six.ensure_binary(id_value))
    return six.ensure_str(res) if res.Defined() else res
