import logging

import requests


logger = logging.getLogger(__name__)


class JugglerClient(object):
    def __init__(self, host, port, source):
        self.url = "http://{host}:{port}/events".format(host=host, port=port)
        self.source = source

    def send_ok(self, host, service, description):
        self.send_event("OK", host, service, description)

    def send_warn(self, host, service, description):
        self.send_event("WARN", host, service, description)

    def send_crit(self, host, service, description):
        self.send_event("CRIT", host, service, description)

    def send_event(self, status, host, service, description):
        data = {
            "source": self.source,
            "events": [{
                "host": host,
                "service": service,
                "status": status,
                "description": description
            }]
        }

        logger.info(data)

        reply = requests.post(self.url, json=data)
        event_status = reply.json()["events"][0]

        logger.info(event_status)

        if event_status["code"] != 200:
            raise Exception(event_status["error"])
