import threading


class Context(threading.local):

    @property
    def stack(self):
        try:
            return self._stack
        except AttributeError:
            self._stack = []
            return self._stack

    def as_dict(self):
        items = {}
        for each in reversed(self.stack):
            items.update(**each)
        return items

    def __call__(self, **kwargs):
        return UpdateContextManager(self, **kwargs)


class UpdateContextManager(object):
    def __init__(self, log_context, **kwargs):
        self.log_context = log_context
        self.fields = kwargs

    def __enter__(self):
        self.log_context.stack.insert(0, self.fields)

    def __exit__(self, exc_type, exc_value, traceback):
        self.log_context.stack.pop(0)


_context = Context()
