import logging
import json
from collections import OrderedDict

from crypta.lib.python.logging.context import _context


class Formatter(logging.Formatter):

    def format(self, record):
        dict_record = OrderedDict()
        dict_record['time'] = self.formatTime(record)
        dict_record['levelStr'] = record.levelname
        dict_record['msg'] = record.getMessage()
        if record.exc_info:
            dict_record['stackTrace'] = self.formatException(record.exc_info)

        dict_record['@fields'] = OrderedDict([
            ('thread', record.threadName),
            ('file', record.pathname),
            ('function', record.funcName),
            ('line', record.lineno),
        ] + list(_context.as_dict().items()))

        return json.dumps(dict_record)
