import functools
import inspect

import memory_profiler
import mock
from six.moves import (
    cStringIO,
    filter,
    range,
)


class CodeMap(memory_profiler.CodeMap):
    def add(self, code, toplevel_code=None):
        if code in self:
            return
        if toplevel_code is None:
            toplevel_code = code
            (sub_lines, start_line) = inspect.getsourcelines(code)
            linenos = list(range(start_line, start_line + len(sub_lines)))
            self._toplevel.append((code.co_filename, code, linenos))
            self[code] = {}
        else:
            self[code] = self[toplevel_code]
        for subcode in filter(inspect.iscode, code.co_consts):
            self.add(subcode, toplevel_code=toplevel_code)


def patched_profile(func=None, logger=None, *args, **kwargs):
    if func is not None:
        if logger is not None:
            stream = cStringIO.StringIO()
            kwargs["stream"] = stream

        original_wrapper = memory_profiler.profile(func, *args, **kwargs)

        @functools.wraps(original_wrapper)
        def wrapper(*args, **kwargs):
            with mock.patch('memory_profiler.CodeMap', side_effect=CodeMap):
                val = original_wrapper(*args, **kwargs)
                if logger is not None:
                    logger.info(stream.getvalue())
                    stream.reset()
                    stream.truncate()

                return val

        return wrapper
    else:
        def inner_wrapper(f):
            return patched_profile(f, logger, *args, **kwargs)

        return inner_wrapper
