import functools
import logging
import requests

Session = requests.Session


def request(method, path, hosts, excluded_hosts=(), schema="http://", session=None, **kwargs):
    session = session or requests
    return send(session, method, path, hosts, excluded_hosts, schema, **kwargs)


get = functools.partial(request, "GET")
post = functools.partial(request, "POST")
put = functools.partial(request, "PUT")


def send(session, method, path, hosts, excluded_hosts, schema, **kwargs):
    logger = logging.getLogger(__name__)

    last_error_message = ""

    for i, host in enumerate(hosts):
        if host in excluded_hosts:
            continue

        try:
            url = "{}{}{}".format(schema, host, path)
            logger.debug("Trying {}".format(url))
            response = session.request(method, url, **kwargs)
            logger.debug("Got response {} {}".format(response, response.text))

            if 200 <= response.status_code < 300:
                if i > 0:
                    hosts[i] = hosts[0]
                    hosts[0] = host

                return response

            last_error_message = "HTTP {} {}".format(response.status_code, response.text)

        except Exception as e:
            logger.warn("Failed to get response from {}: {}".format(host, e))
            last_error_message = str(e)
            continue

    raise Exception("No 2xx response from any of hosts: {}, last error message: {}".format(hosts, last_error_message))
