#include <crypta/lib/python/native_yt/cpp/operations.h>
#include <util/generic/vector.h>
#include <thread>
#include <future>

using namespace NYT;

static TUserJobSpec MapperUserJobSpec(const NNativeYT::TOperationArgs& args) {
    TUserJobSpec spec{};
    for (const auto& each : args.Files.Mapper) {
        spec.AddFile(each);
    }
    return spec;
}

static TUserJobSpec ReducerUserJobSpec(const NNativeYT::TOperationArgs& args) {
    TUserJobSpec spec{};
    for (const auto& each : args.Files.Reducer) {
        spec.AddFile(each);
    }

    return spec;
}

NNativeYT::TOperationGUID NNativeYT::RunMap(const TString& mapperName,
                                            const NNativeYT::TOperationArgs& args) {
    TMapOperationSpec spec;
    spec.MapperSpec(MapperUserJobSpec(args));
    auto result = NNativeYT::Execute(mapperName, spec, args);
    return result;
}

NNativeYT::TOperationGUID NNativeYT::RunReduce(const TString& reducerName,
                                               const TVector<TString>& sortBy,
                                               const TVector<TString>& reduceBy,
                                               const NNativeYT::TOperationArgs& args) {
    TReduceOperationSpec spec;
    spec.SortBy(TSortColumns(sortBy));
    spec.ReduceBy(TSortColumns(reduceBy));
    spec.ReducerSpec(ReducerUserJobSpec(args));
    auto result = NNativeYT::Execute(reducerName, spec, args);
    return result;
}

NNativeYT::TOperationGUID NNativeYT::RunMapReduce(const TString& mapperName,
                                                  const TString& reducerName,
                                                  const TVector<TString>& reduceBy,
                                                  const TVector<TString>& sortBy,
                                                  const NNativeYT::TOperationArgs& args) {
    TMapReduceOperationSpec spec;
    spec.SortBy(TSortColumns(sortBy));
    spec.ReduceBy(TSortColumns(reduceBy));
    spec.MapperSpec(MapperUserJobSpec(args));
    spec.ReducerSpec(ReducerUserJobSpec(args));
    auto result = NNativeYT::Execute(NNativeYT::CombinedName(mapperName, reducerName), spec, args);
    return result;
}

NNativeYT::TOperationGUID NNativeYT::RunMapReduceWithCombiner(const TString& mapperName,
                                                              const TString& combinerName,
                                                              const TString& reducerName,
                                                              const TVector<TString>& reduceBy,
                                                              const TVector<TString>& sortBy,
                                                              const NNativeYT::TOperationArgs& args) {
    TMapReduceOperationSpec spec;
    spec.SortBy(TSortColumns(sortBy));
    spec.ReduceBy(TSortColumns(reduceBy));
    spec.MapperSpec(MapperUserJobSpec(args));
    spec.ReducerSpec(ReducerUserJobSpec(args));
    auto result = NNativeYT::Execute(NNativeYT::CombinedName(mapperName, combinerName, reducerName), spec, args);
    return result;
}

NNativeYT::TOperationGUID NNativeYT::RunJoinReduce(const TString& reducerName,
                                                   const TVector<TString>& joinBy,
                                                   const NNativeYT::TOperationArgs& args) {
    TJoinReduceOperationSpec spec;
    spec.JoinBy(TSortColumns(joinBy));
    spec.ReducerSpec(ReducerUserJobSpec(args));
    auto result = NNativeYT::Execute(reducerName, spec, args);
    return result;
}

bool NNativeYT::IsOperationComplete(const ITransactionPtr& transaction, const NNativeYT::TOperationGUID& guid) {
    auto state = transaction->CheckOperation(guid);
    return (state == EOperationBriefState::Completed);
}
