#pragma once

#include <mapreduce/yt/interface/client.h>
#include <mapreduce/yt/interface/operation.h>
#include <util/generic/vector.h>

#include <crypta/lib/python/native_yt/cpp/registrar.h>

namespace NNativeYT {
    using TOperationGUID = TGUID;

    TOperationGUID RunMap(const TString& mapperName, const TOperationArgs& args);
    TOperationGUID RunReduce(const TString& reducerName, const TVector<TString>& sortBy,
                             const TVector<TString>& reduceBy, const TOperationArgs& args);
    TOperationGUID RunMapReduce(const TString& mapperName, const TString& reducerName,
                                const TVector<TString>& reduceBy, const TVector<TString>& sort_by, const TOperationArgs& args);
    TOperationGUID RunMapReduceWithCombiner(const TString& mapperName, const TString& combinerName, const TString& reducerName,
                                            const TVector<TString>& reduceBy, const TVector<TString>& sort_by, const TOperationArgs& args);
    TOperationGUID RunJoinReduce(const TString& reducerName,
                                 const TVector<TString>& joinBy, const TOperationArgs& args);

    bool IsOperationComplete(const NYT::ITransactionPtr& transaction, const TOperationGUID& guid);
}
