#pragma once

#include <util/generic/buffer.h>
#include <util/stream/fwd.h>
#include <util/ysaveload.h>

#include <contrib/libs/protobuf/src/google/protobuf/message_lite.h>

namespace NNativeYT {
    template <class TStateType>
    class TProtoState {
    public:
        TProtoState()
            : State()
        {
        }
        TProtoState(const TBuffer& buffer)
            : TProtoState()
        {
            Y_PROTOBUF_SUPPRESS_NODISCARD State.ParseFromArray(buffer.Data(), buffer.Size());
        }
        void Save(IOutputStream& output) const {
            ::Save(&output, State);
        }
        void Load(IInputStream& input) {
            ::Load(&input, State);
        }
        TStateType* operator->() {
            return &State;
        }
        TStateType Get() const {
            return State;
        }

    private:
        TStateType State;
    };
}
