#include <crypta/lib/python/native_yt/cpp/registrar.h>
#include <util/generic/singleton.h>

namespace NNativeYT {
    NYT::TOperationId Execute(const TString& name,
                              const NAny::TAny& spec,
                              const TOperationArgs& args) {
        return TJobRegistrar::Get()->Job(name)({.Spec = spec,
                                                .Source = args.Source,
                                                .Destination = args.Destination,
                                                .Transaction = args.Transaction,
						.State = {
                                                    .Mapper = args.State.Mapper,
                                                    .Reducer = args.State.Reducer,
                                                    .Combiner = args.State.Combiner,
                                                },
                                                .OptionsSpec = args.OptionsSpec})
            .Operation;
    }

    TJobRegistrar* TJobRegistrar::Get() {
        return Singleton<TJobRegistrar>();
    }

    bool IsRegistered(const TString& name) {
        try {
            NYT::TJobFactory::Get()->GetJobFunction(name.c_str());
        } catch (yexception&) {
            return false;
        }
        return true;
    }
}
