import logging
import os

logger = logging.getLogger(__name__)


class NirvanaTransaction(object):
    TRANSACTION_ID_ENVIRON_FIELD = 'YT_TRANSACTION'

    def __init__(self, yt_client):
        self.yt_client = yt_client

    @staticmethod
    def get_nirvana_transaction_id():
        return os.environ.get(NirvanaTransaction.TRANSACTION_ID_ENVIRON_FIELD)

    def __enter__(self, *args, **kwargs):
        self.nirvana_transaction_id = self.get_nirvana_transaction_id()
        assert self.nirvana_transaction_id is not None, \
            'Nirvana transaction not found at environment variable {}'.format(self.TRANSACTION_ID_ENVIRON_FIELD)
        logger.info('Found nirvana transaction: {}'.format(self.nirvana_transaction_id))

        self.transaction = self.yt_client.Transaction(transaction_id=self.nirvana_transaction_id)
        self.transaction.__enter__(*args, **kwargs)
        return self.transaction

    def __exit__(self, *args, **kwargs):
        self.transaction.__exit__(*args, **kwargs)
