import threading

import requests


class PerThreadSessionPool:
    def __init__(self):
        self._pool = {}
        self._lock = threading.Lock()

    def get_session(self):
        ident = threading.get_ident()
        with self._lock:
            if ident in self._pool:
                return self._pool[ident]
            else:
                session = requests.Session()
                self._pool[ident] = session
                return session
