import contextlib
import datetime
import time


@contextlib.contextmanager
def period(weeks=0, days=0, hours=0, minutes=0, seconds=0):
    period_delta = datetime.timedelta(weeks=weeks, days=days, hours=hours, minutes=minutes, seconds=seconds)
    start_time = datetime.datetime.now()
    yield
    finish_time = datetime.datetime.now()
    sleep_delta = max(start_time + period_delta - finish_time, datetime.timedelta())
    time.sleep(sleep_delta.total_seconds())
