from google.protobuf import (
    json_format,
    message,
)
from google.protobuf.message_factory import MessageFactory

from mapreduce.yt.interface.protos import extension_pb2
from yt.yson import convert


def read_proto_from_dict(initial, dictionary):
    factory = MessageFactory()
    for field in initial.DESCRIPTOR.fields:
        if not field.message_type:
            continue
        clazz = factory.GetPrototype(field.message_type)
        string_value = dictionary.get(field.name)
        if string_value is not None:
            value = clazz.FromString(string_value)
            getattr(initial, field.name).MergeFrom(value)

    return initial


def get_name(descriptor):
    if descriptor.GetOptions().HasExtension(extension_pb2.column_name):
        return descriptor.GetOptions().Extensions[extension_pb2.column_name]
    return descriptor.name


def get_value(value):
    return value.SerializeToString() if isinstance(value, message.Message) else value


def row_transformer(protobuf):
    def row_transformer(row):
        proto = json_format.ParseDict(convert.yson_to_json(row), protobuf())
        return {
            get_name(descriptor): get_value(value)
            for descriptor, value in proto.ListFields()
        }
    return row_transformer


def from_string(proto_class, s):
    proto = proto_class()
    proto.ParseFromString(s)
    return proto
