from cython.operator cimport dereference
from library.python.protobuf.dynamic_prototype.dynamic_prototype cimport (
    get_dynamic_message,
    Message,
    TDynamicMessage,
)
import six
from util.generic.string cimport TString
from util.generic.ptr cimport TIntrusivePtr


cdef extern from "crypta/lib/native/proto_secrets/remove_secrets.h" namespace "NCrypta::NProtoSecrets" nogil:
    cdef void RemoveSecrets(Message&) except +;


def get_copy_without_secrets(proto):
    cdef TDynamicMessage cpp_proto = get_dynamic_message(proto)

    if not dereference(cpp_proto.Get()).ParseFromString(proto.SerializeToString()):
        raise Exception("Failed to transfer protobuf from Python to C++")

    RemoveSecrets(dereference(cpp_proto.Get()))

    result = proto.__class__()

    if not result.ParseFromString(dereference(cpp_proto.Get()).SerializeAsString()):
        raise Exception("Failed to transfer protobuf from C++ to Python")

    return result
