import base64

from crypta.lib.python import tskv
from crypta.lib.python.rtmr.test_framework import json_to_lenval
import six

DEFAULT_USERAGENT = "Mozilla/5.0 (Linux; Android 6.0.1; Redmi 4A) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/71.0.3578.99 Mobile Safari/537.36"
BROWSER_INFO_TEMPLATE = {
    "adb": "2",
    "cn": "1",
    "cpf": "1",
    "ds": "0,0,45,244,19,0,0,1692,503,,,,2043",
    "et": "1572959820",
    "fp": "1199",
    "fpr": "67501995301",
    "gdpr": "14",
    "hi": "",
    "hid": "491028869",
    "i": "20191105161659",
    "la": "ru-ru",
    "ls": "460385175103",
    "ns": "1572959816841",
    "ntf": "1",
    "pv": "1",
    "rn": "1060270209",
    "rqn": "94",
    "rqnl": "1",
    "s": "1920x1080x24",
    "sk": "1",
    "st": "1572959820",
    "ti": "10",
    "u": "157233924179295978",
    "v": "1734",
    "w": "1903x969",
    "z": "180",
    "en": "",
    "c": "1"
}


def seriralize_browser_info(value):
    if isinstance(value, six.binary_type):
        return value
    if isinstance(value, six.text_type):
        return value.encode('utf-8')

    browserinfo = dict(BROWSER_INFO_TEMPLATE)
    if value:
        browserinfo.update(value)

    return ":".join(":".join(pair) for pair in six.iteritems(browserinfo))


class BsWatchLogSerializer(json_to_lenval.JsonToLenval):
    def __init__(self):
        def make_row(value):
            if isinstance(value, (six.binary_type, six.text_type)):
                return value

            row = {
                "url": value["url"],
                "icookie": value.get("uniqid", "0"),
                "domainuserid": value.get("domainuserid", "0"),
                "useragent": value.get("useragent", DEFAULT_USERAGENT),
                "browserinfo": seriralize_browser_info(value.get("browserinfo")),
                "unixtime": value.get("unixtime")
            }

            optional_fields = ("referer", "regionid", "clientip", "clientip6", "counterid", "sslsessionticketiv", "uniqid", "tcpport", "watchid")
            for field in optional_fields:
                if field in value:
                    row[field] = value[field]

            if "title_base64" in value:
                row["title"] = base64.b64decode(value["title_base64"])
            elif "title" in value:
                row["title"] = value.get("title").encode("utf-8")

            return tskv.dict_to_tskv(row)

        super(BsWatchLogSerializer, self).__init__(make_row)
