import zlib

from crypta.lib.python.rtmr.log_serializers import rtmr_codec
from crypta.lib.python.rtmr.test_framework import json_to_lenval
import six


class LogfellerSerializer(json_to_lenval.JsonToLenval):
    def __init__(self, item_serializer=None):
        item_serializer = item_serializer or (lambda x: x)

        def make_chunk(value):
            if isinstance(value, (six.binary_type, six.text_type)):
                return value

            return rtmr_codec.encode_value(zlib.compress(b"\n".join(item_serializer(item) for item in value)), b"gzip")

        super(LogfellerSerializer, self).__init__(make_chunk)
