import six
DELIMITER = "@@"

TAIL_FIELDS = ("unixtime", "ips", "yuid")

REQUIRED_FIELDS = ("HTTP_REFERER", "user_agent", "url") + TAIL_FIELDS


def serialize_redir_log(row):
    if isinstance(row, (six.binary_type, six.text_type)):
        return row

    assert all(key in row for key in REQUIRED_FIELDS)

    tail = DELIMITER.join(row.pop(field) for field in TAIL_FIELDS)

    return DELIMITER.join("=".join(pair) for pair in six.iteritems(row)) + DELIMITER + tail
