from crypta.lib.python import tskv
from crypta.lib.python.rtmr.test_framework import (
    json_to_lenval,
)
import six


class BaseTskvSerializer(json_to_lenval.JsonToLenval):
    tskv_format = None
    header = None

    def __init__(self):
        def make_row(value):
            if isinstance(value, (six.binary_type, six.text_type)):
                return value

            row = {
                "unixtime": "1544450126",
            }
            if self.tskv_format:
                row["tskv_format"] = self.tskv_format

            for k, v in six.iteritems(value):
                row[k] = v

            return "\t".join(["tskv", tskv.dict_to_tskv(row)])

        super(BaseTskvSerializer, self).__init__(make_row)


class BsEventLogSerializer(BaseTskvSerializer):
    tskv_format = "bs-event-log"


class BsHitLogSerializer(BaseTskvSerializer):
    tskv_format = "bs-hit-log"


class RedirLogSerializer(BaseTskvSerializer):
    pass
