import google.protobuf.json_format


def make_proto_parser(proto):
    def parse_value(raw_value):
        value = proto()
        value.ParseFromString(raw_value)
        return google.protobuf.json_format.MessageToDict(value)

    return parse_value


def parse_state(raw_value):
    return raw_value


def make_state_proto_parser(proto):
    parse_proto = make_proto_parser(proto)

    def parse_value(raw_value):
        return parse_proto(parse_state(raw_value))

    return parse_value
