import google.protobuf.json_format


def make_proto_serializer(proto):
    def serialize_value(value):
        return google.protobuf.json_format.ParseDict(value, proto()).SerializeToString()

    return serialize_value


def serialize_state(value):
    return value


def make_state_proto_seralizer(proto):
    proto_serializer = make_proto_serializer(proto)

    def serialize_value(value):
        return serialize_state(proto_serializer(value))

    return serialize_value
