import logging
import os

from crypta.lib.python import yaml_config
from crypta.lib.python.logging import logging_helpers
from crypta.lib.python.proto_secrets import proto_secrets


def run(main_func, config_type, desc, logger_configurator=logging_helpers.configure_stdout_logger):
    log_level = os.environ.get("LOG_LEVEL", "INFO")
    logger_configurator(logging.getLogger(), level=log_level)
    config = yaml_config.parse_config_from_args(config_type, desc)

    logger = logging.getLogger(main_func.__name__)
    logger.info("Config:\n%s", proto_secrets.get_copy_without_secrets(config))

    main_func(config, logger)

    logger.info("Completed successfully")
