from libcpp cimport bool


cdef extern from"crypta/lib/native/sampler/rest_sampler.h" namespace "NCrypta::TRestSampler::EMode" nogil:
    cdef enum EMode "EMode":
        Equal,
        Less


cdef extern from "crypta/lib/native/sampler/rest_sampler.h" namespace "NCrypta" nogil:
    cdef cppclass TRestSampler:
        @staticmethod
        bool Passes[TValue](TValue value, size_t denominator, size_t rest, EMode mode)


def PassesEqual(long value, size_t denominator, size_t rest):
    return TRestSampler.Passes(value, denominator, rest, Equal)


def PassesLess(long value, size_t denominator, size_t rest):
    return TRestSampler.Passes(value, denominator, rest, Less)
