import inspect
import os

try:
    import luigi

    def is_luigi_task(cls):
        return issubclass(cls, luigi.Task)

except ImportError:
    def is_luigi_task(cls):
        return False


def get_class_from_frame(fr):
    args, _, _, value_dict = inspect.getargvalues(fr)
    if len(args) and args[0] == 'self':
        instance = value_dict.get('self', None)
        if instance:
            return getattr(instance, '__class__', None)
    return None


def get_outer_luigi_task_name(current_frame, frames_left):
    if not current_frame:
        return None

    current_class = get_class_from_frame(current_frame)

    if current_class and is_luigi_task(current_class):
        return current_class.__name__
    elif frames_left > 0:
        return get_outer_luigi_task_name(current_frame.f_back, frames_left - 1)
    else:
        return None


def detect_script_name(skip_locations=None, luigi_search_depth=10):
    current_frame = inspect.currentframe()
    luigi_task = get_outer_luigi_task_name(current_frame, luigi_search_depth)
    if luigi_task:
        return luigi_task
    elif current_frame.f_back:
        skip_locations = skip_locations or []
        stack = inspect.stack()
        for i in range(1, len(stack)):
            fi = inspect.getframeinfo(stack[i][0])
            if any(fi.filename.startswith(location) for location in skip_locations):
                continue
            return "{}__{}".format(os.path.normpath(fi.filename), fi.function).replace(".", "_").replace("/", "_")
        return 'unknown'
    else:
        return 'unknown'
