from crypta.lib.python.shared_data_structures.immutable_shareable_list import ImmutableShareableList


class ImmutableShareableDict:
    capacity_scale = 2

    def __init__(self, data=None, name=None):
        self.owning = data is not None
        data = self.build_list(data)
        self.list = ImmutableShareableList(sequence=data, name=name)

    @property
    def name(self):
        return self.list.shm.name

    def build_list(self, data):
        if data is None:
            return None

        result = [None] * len(data) * 2 * self.capacity_scale
        for key, value in data.items():
            i = self.get_index(result, key)
            result[i * 2] = key
            result[i * 2 + 1] = value

        return result

    @staticmethod
    def get_index(list_, key):
        size = len(list_) // 2
        h = hash(key) % size
        while list_[h * 2] is not None and list_[h * 2] != key:
            h = (h + 1) % size
        return h

    def get(self, key):
        return self.list[self.get_index(self.list, key) * 2 + 1]

    def close(self):
        self.list.close(self.owning)
