import os

import solomon

SOLOMON_TOKEN_ENV_VAR = "SOLOMON_TOKEN"


def get_auth_provider(oauth_token=None):
    token = oauth_token or os.getenv(SOLOMON_TOKEN_ENV_VAR)
    return solomon.OAuthProvider(token) if token else None


def create_solomon_reporter(oauth_token=None, **kwargs):
    return solomon.BasePushApiReporter(auth_provider=get_auth_provider(oauth_token), **kwargs)


def create_solomon_reporter_from_config(config):
    return solomon.BasePushApiReporter(
        config.Project,
        config.Cluster,
        config.Service,
        "{}://{}:{}".format(config.Schema, config.Host, config.Port),
        common_labels=config.Labels,
        auth_provider=get_auth_provider(config.OauthToken)
    )


def create_throttled_solomon_reporter(push_interval, oauth_token=None, **kwargs):
    return solomon.ThrottledPushApiReporter(push_interval=push_interval, auth_provider=get_auth_provider(oauth_token), **kwargs)


def report_metrics_to_solomon(project, cluster, service, metrics, oauth_token=None):
    solomon_reporter = solomon.BasePushApiReporter(
        project=project,
        cluster=cluster,
        service=service,
        url='http://solomon.yandex.net',
        auth_provider=get_auth_provider(oauth_token),
        sensor_name_label='metric',
    )

    for metric in metrics:
        metric_name = metric['labels']['metric']
        solomon_reporter.set_value(metric_name, metric['value'], labels=metric['labels'])
