# Spine

Library for generating configs which are interconnected between multiple monitoring 
and scheduling systems

### General overview
- All configs are organized in a tree of ConfigRegistry objects
- Configs are added to ConfigRegistry with generators.
- Generators can provide configs for multiple systems.
- Generators are responsible for connecting configs together
(e.g. connecting Solomon alerts and Juggler aggregate checks using the same raw juggler signals).
- All configs are annotated with a registry tag.
This tag is then used by binaries to extract configs for a specific system (e.g. Juggler aggregate checks)

### Modules
- [arcadia_ci](arcadia_ci/README.md) - [Arcadia CI](https://docs.yandex-team.ru/ci/) [a.yaml](https://docs.yandex-team.ru/ci/basics) generator
- [config_registry](config_registry) - base class for storing tagged configs
- [consts](consts) - common constants used in multiple spine modules
- [event_processing_utils](event_processing_utils/README.md) - alerts and checks for metrics generated by
[event_processing](https://a.yandex-team.ru/arc/trunk/arcadia/crypta/lib/native/event_processing) library
- [juggler](juggler/README.md) - [Juggler](https://juggler.yandex-team.ru/) aggregate checks
- [logfeller](logfeller/README.md) - [Logfeller](https://wiki.yandex-team.ru/logfeller/) unparsed records checks
- [rtmr_utils](rtmr_utils/README.md) - checks and alerts for [RTMR](https://rtmr.yandex-team.ru) tables and operations
- [sandbox](sandbox/README.md) - [Sandbox](https://sandbox.yandex-team.ru) schedulers with ability 
to generate corresponding Juggler aggregate checks
- [solomon](solomon/README.md) - [Solomon](https://solomon.yandex-team.ru/) alerts with ability 
to generate corresponding Juggler aggregate checks
- [yt](yt/README.md) - various Solomon metrics for [YT](https://yt.yandex-team.ru/) paths
with ability to generate corresponding Solomon alerts and Juggler checks
