from __future__ import absolute_import
import collections


class ConfigRegistry(object):
    def __init__(self):
        self.configs = collections.defaultdict(list)
        self.subproviders = []

    def add_subregistry(self, subprovider):
        assert isinstance(subprovider, ConfigRegistry)
        self.subproviders.append(subprovider)
        return subprovider

    def store(self, tag, config):
        self.configs[tag].append(config)
        return config

    def get_configs(self, tag):
        return sum((subprovider.get_configs(tag) for subprovider in self.subproviders), self.configs[tag])
