import datetime

from crypta.lib.python.solomon.proto import alert_pb2
from crypta.lib.python.spine.juggler import consts


def get_invalid_events_check(dc_check_generator):
    """
    :param dc_check_generator: :class:`~crypta.lib.python.spine.solomon.solomon_check_generator.DcSolomonCheckGenerator`
    :return: :class:`~crypta.lib.python.spine.juggler.juggler_aggregate_check.JugglerAggregateCheck`
    """
    return get_zero_threshold_check(
        dc_check_generator.get_sensor("worker.event.count.invalid"),
        "invalid events: {{ pointValue }}",
    )


def get_unsupported_events_check(dc_check_generator):
    """
    :param dc_check_generator: :class:`~crypta.lib.python.spine.solomon.solomon_check_generator.DcSolomonCheckGenerator`
    :return: :class:`~crypta.lib.python.spine.juggler.juggler_aggregate_check.JugglerAggregateCheck`
    """
    return get_zero_threshold_check(
        dc_check_generator.get_sensor("worker.event.count.unsupported"),
        "unsupported events: {{ pointValue }}",
    )


def get_zero_threshold_check(solomon_sensor, juggler_description):
    """
    :param solomon_sensor: :class:`~crypta.lib.python.spine.solomon.solomon_sensor.SolomonSensor`
    :param juggler_description: will be displayed in Juggler aggregate check, can contain mustache template https://wiki.yandex-team.ru/solomon/userguide/alerting/#templates
    :return: :class:`~crypta.lib.python.spine.juggler.juggler_aggregate_check.JugglerAggregateCheck`
    """
    return solomon_sensor.create_threshold_check(
        aggregation=alert_pb2.MAX,
        predicate=alert_pb2.GT,
        threshold=0,
        period=datetime.timedelta(minutes=5),
        description=juggler_description,
    ).add_nodata_mode(consts.NoDataMode.force_ok)
