from __future__ import absolute_import

from crypta.lib.python.spine.consts import environment


class AggregateHost(object):
    def __init__(self, host, environment):
        self.host = host
        self.environment = environment


class AggregateHosts(object):
    def __init__(self, production_host, testing_host):
        self.production_host = AggregateHost(production_host, environment.STABLE)
        self.testing_host = AggregateHost(testing_host, environment.TESTING)

    def __iter__(self):
        yield self.production_host
        yield self.testing_host
