from __future__ import absolute_import

from crypta.lib.python.spine.consts import environment
import crypta.utils.run_periodic_task.lib.hosts as periodic_task_hosts

ALL = "all"

DEFAULT_REFRESH_TIME = 300
DEFAULT_TTL = 1800
FREQUENT_REFRESH_TIME = 60
FREQUENT_TTL = 300

MARK = "crypta-yt-mark"
NAMESPACE = "crypta"

DEFAULT_UNREACH_SERVICES = (":UNREACHABLE",)

LOGFELLER_RAW_HOST = "crypta-logfeller-raw"

ENV_TO_PERIODIC_TASK_HOST = {
    environment.PRODUCTION: periodic_task_hosts.PROD_HOST,
    environment.STABLE: periodic_task_hosts.PROD_HOST,
    environment.TESTING: periodic_task_hosts.TEST_HOST,
}


class GroupType(object):
    """
    https://docs.yandex-team.ru/juggler/aggregates/groups#group-types
    """
    conductor = "CGROUP"
    deploy = "DEPLOY"
    host = "HOST"
    nanny = "NANNY"
    qloud = "QLOUD"
    events = "EVENTS"


class NoDataMode(object):
    """
    https://docs.yandex-team.ru/juggler/aggregates/aggregators#no-data
    """
    force_ok = "force_ok"
    force_crit = "force_crit"
    force_warn = "force_warn"
    skip = "skip"


class UnreachMode(object):
    """
    https://docs.yandex-team.ru/juggler/aggregates/aggregators#unreach-service
    """
    force_ok = "force_ok"
    skip = "skip"


class Hitman(object):
    failed_jobs = 'FAILED_JOBS'
    succeeded_jobs = 'SUCCEEDED_JOBS'
