import datetime

from crypta.lib.python.solomon.proto import alert_pb2
from crypta.lib.python.spine.juggler import consts
from crypta.lib.python.spine.solomon import (
    solomon_alert_registry,
    solomon_alert_utils,
)


def logfeller_service(stream):
    return stream.replace("@", "_")


def create_logfeller_unprased_records_alert(stream):
    return solomon_alert_utils.create_threshold_alert(
        name=logfeller_service(stream),
        project_id="crypta_stats",
        time_aggregation=alert_pb2.MAX,
        predicate=alert_pb2.GT,
        threshold=0,
        period=datetime.timedelta(hours=1),
        selectors={
            "project": "logfeller",
            "cluster": "hahn",
            "service": "indexing",
            "sensor": "parsing",
            "count": "unparsed-records",
            "stream-name": stream,
        },
        group_by_labels=None,
        juggler_service=logfeller_service(stream),
        juggler_host=consts.LOGFELLER_RAW_HOST,
        juggler_description="Unparsed records: {{pointValue}}")


def add_unprased_records_check(juggler_check_generator, stream):
    """
    :param juggler_check_generator: :class:`~crypta.lib.python.spine.juggler.juggler_check_generator.JugglerCheckGenerator`
    :param stream: path to Logbroker topic in format "account@dir1@dir2-topic"
    :return: :class:`~crypta.lib.python.spine.juggler.juggler_aggregate_check.JugglerAggregateCheck`
    """
    solomon = solomon_alert_registry.SolomonAlertRegistry()
    juggler_check_generator.add_subregistry(solomon)
    solomon.add_solomon_alert(create_logfeller_unprased_records_alert(stream))

    return juggler_check_generator.any(logfeller_service(stream)) \
        .add_nodata_mode(consts.NoDataMode.force_ok) \
        .set_child(consts.LOGFELLER_RAW_HOST) \
        .set_host("crypta-logfeller")
